<?php include( 'inc/template.php' );?>
<div class="container-fluid flex-grow-1 container-p-y">
	<nav aria-label="breadcrumb">
	<ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
	<li class="breadcrumb-item"><a href="inquiry_add.php">Inquiry Add</a></li>
    <li class="breadcrumb-item">Inquiry List</li>
    </ol>
</nav>
<div class="card">
<div class="card-datatable table-responsive pt-0">
<table class="datatables-ajax table table-bordered table-responsive">
<thead>
    <tr>
        <th style="display: none"></th>
        <th>Date</th>
        <th>Name</th>
        <th>Mobile</th>
		<th>Remarks</th>
        <th>Inquiry Type</th>
        <th>Follow-Up Status</th>
		<th>Action</th>
    </tr>
</thead>
<tbody>
    <?php
    // Fetch inquiries along with customer details
    $nox = 0;
    $ure=mysqli_query($conn,"select * from inquiries order by ABS(id) desc");
    while($urow=mysqli_fetch_array($ure)) {
        $id=$urow[0];
        $no=1 + $nox++;
        $uupQry="UPDATE inquiries SET orderlist='$no' WHERE id='$id'";
        $uuresult=mysqli_query($conn,$uupQry);
    }             

    // Get inquiries with customer data
    $result = mysqli_query($conn, "SELECT i.*, c.name AS customer_name, c.phone AS customer_phone FROM inquiries i JOIN customers c ON i.customer_id = c.id ORDER BY i.id DESC");
    
    while ($row = mysqli_fetch_array($result)) {
		$statusclass = strtolower($row['followup_status']) == 'pending'   ? 'bg-warning' :
               (strtolower($row['followup_status']) == 'done'     ? 'bg-success' :
               (strtolower($row['followup_status']) == 'cancelled'? 'bg-danger'  :
               (strtolower($row['followup_status']) == 'closed'   ? 'bg-secondary' : 'bg-info'))); 

    ?>
    <tr class="showtr">
        <td style="display: none"><?php echo $row['orderlist']; ?></td>
        <td><?php echo htmlspecialchars(date('d-m-Y', strtotime($row['inquiry_date']))); ?></td>
        <td><a href="inquiry_details.php?inquiryid=<?php echo $row['id']; ?>"><?php echo htmlspecialchars(ucwords($row['customer_name'])); ?></td>
        <td><?php echo htmlspecialchars($row['customer_phone']); ?></td>
		<td><?php echo htmlspecialchars(ucwords($row['remarks'])); ?></td>
        <td><?php echo htmlspecialchars(ucwords(strtolower($row['inquiry_type']))); ?></td>
        
        <td><span class="badge <?php echo $statusclass; ?> bg-glow"><?php echo htmlspecialchars(ucwords(strtolower($row['followup_status']))); ?></span><br><small class="text-muted">
        <?php echo !empty($row['last_followup_date']) ? 'Last: ' . date('d-m-Y', strtotime($row['last_followup_date'])) : ''; ?></small>
        <td><button type="button" class="btn btn-xs btn-warning" onclick="window.location.href='inquiry_add.php?id=<?php echo $row['id']; ?>'">
                <i class="far fa-edit"></i></button>
            <button type="button" id="<?php echo $row['id']; ?>" class="btn btn-xs btn-danger delete"><i class="far fa-trash-alt"></i></button>
        </td>
    </tr>
    <?php } ?>
</tbody>
</table>
</div>
</div>
</div>
<script>
$(document).ready(function () {
    
    // Handle delete action
    $(document).on('click', '.delete', function () {
    var id = $(this).attr("id");
    var row = $(this).closest('tr');
    if (confirm('Are you sure you want to delete this record?')) {
        $.ajax({
            url: 'controller/InquiryController.php',
            method: 'POST',
            data: { id: id, action: 'Delete' },
            dataType: 'json', // Expect JSON response
            success: function (response) {
                console.log('Server Response:', response); // Log the response
                if (response.status === 'Delete') {
                    toastr.success(response.message);
                    row.css('background-color', '#63ba8f').fadeOut(800, function() {
                        $(this).remove();
                    });
                } else {
                    toastr.error(response.message);
                }
            },
            error: function () {
                toastr.error('Error while deleting record.');
            }
        });
    }
});

});

</script>
<?php include('inc/footer.php');?>